uniform vec3		sundir;
uniform vec3		camdir;

uniform vec3		moondir;
uniform vec3		moonColor;
uniform float		moonCoronasMul;

varying float		h;
varying vec3		vPOS;
varying vec3		cnormal;
//varying float		depth;	
uniform float 		inScatter;
uniform float 		sunpower;
uniform vec3		fogColor;
uniform vec3		zenithColor;
uniform vec3		horizonColor;
uniform float 		extintion;

// costanti passate allo shader
uniform vec3  SUN; 	// = colore del sole
uniform vec3  cBr; 	// = RayLeigh
uniform vec3  cBm; 	// = Mie	
uniform	vec3  C0; 	// = cBr+cBm;	
uniform vec3  C1; 	// = 1.0/(cBr+cBm)*SUN;

uniform float 	C4;	// = (1-g)^2
uniform float 	C5;	// = 1+g^2
uniform float 	C6;	// = 2*g
uniform float 	C7;	// = 3/2
uniform float 	fogMultiplier;
uniform float	vScale;

uniform sampler2D	starsTex;
uniform sampler2D	cloudsTex;
uniform sampler2D	cirrusTex;
//uniform sampler2D	cloudsDetailTex;
uniform sampler2D	moonTex;
uniform vec2 		moonRadius;
varying vec2		texcoords;
varying vec2		moonTexcoords;
varying vec2		cloudsTexcoords,
					//cloudsTexcoords2,
					cloudsTexcoords3,
					cloudsTexcoords4,
					cloudsTexcoords5;
uniform float		cDensity;
varying mat3		TBN;
varying mat3		iTBN;
uniform vec2 		cloudsMat;
uniform vec3 		cloudsColor;
uniform vec2 		ofs;

uniform float		sunDiskPower;

uniform vec3 		earth_center;

////////////////////////////

void main()
{
	/*vec3 sunpos=sundir*vec3(-100.0);
	vec3 tnormal=normalize(cnormal);
	float cos=dot(-sundir,tnormal);
	float cos2=(1.0-step(-cos,0.9998))*sunDiskPower;
	
	float F1=(1.0 + cos*cos);
	float F2=(C4/pow(C5-C6*cos,C7));
	
	vec3 Br = cBr*F1;
	vec3 Bm = cBm*F2;
	
	float rf = h;
	float mf = h*0.1;
	vec3 	rd=cBr,
			md=cBm;
	if(abs(rf) > 0.01) rd *=  (1.0 - exp(-rf)) / rf;
	if(abs(mf) > 0.01) md *=  (1.0 - exp(-mf)) / mf;
	vec3 cC0=(rd*rf + md*mf);
	vec3 Fex=exp(-cC0*5000000.0);
	vec3 LinMul=C1*(1.0-Fex);
	vec3 Lin = (Br+Bm)*LinMul*inScatter; 
	vec3 baseColor=mix(zenithColor,horizonColor,h);
	vec3 scatterColor=baseColor + Lin;
	
	// MOON & STARS ///////////////////////////////////////////////
	float stars=texture2D(starsTex,texcoords.st).x;
	vec3 finalColor=scatterColor + cos2*Lin;
	float moonCos=pow(max(dot(moondir,tnormal),0.0),50.0);
	vec4 moonTexColor=vec4(texture2D(moonTex,((moonTexcoords.st-0.5)*moonRadius)+0.5).x) + vec4(vec3(moonCos*moonCoronasMul),1.0);
	vec3 skycolor=max(moonTexColor.xyz*moonColor + finalColor + stars*moonColor*0.2,0.0);
	
// CLOUDS ////////////////////////////////////////////
	vec3 scatterLight=pow(max(-cos,0.0),40.0)*SUN;
	vec3 backLight=scatterLight*cloudsMat.y;
	
	//float cloudScatter=max(0.0,-cos*0.5+0.5);
	vec3 L=sunpos-vPOS;
	vec3 tL=iTBN*L;		// convert L to tangent space
	tL=normalize(tL);
	
	//float t=sin(ofs.x*100.0)*0.5+0.5;
	float cloudsNoise=(texture2D(cirrusTex,cloudsTexcoords.st).g+texture2D(cirrusTex,cloudsTexcoords3.st).b)*0.5;
	float cloudsNoise2=(texture2D(cirrusTex,cloudsTexcoords4.st).r+texture2D(cirrusTex,cloudsTexcoords5.st).r)*0.5;
	
	float accDens=0.0;
	float disp=0.05;
	for(int i=0; i<4; i++)
	{
		accDens+=((texture2D(cirrusTex,cloudsTexcoords.st+tL.xy*vec2(disp,-disp)).g+texture2D(cirrusTex,cloudsTexcoords3.st+tL.xy*vec2(disp,-disp)).b)*0.5);
		disp+=0.01;
	}
	float cloudAlpha2=1.0-accDens*0.25;
	cloudAlpha2=pow(cloudAlpha2,4.0);//max((cloudAlpha2-0.2)*1.25,0.0);
	
	float d=cDensity;
	
	float OneMinusDensity=1.0-clamp(d,0.0,1.0);
	float c = max(cloudsNoise-d,0.0);
	float c2 = max(cloudsNoise2-d,0.0);
	
	float cloudsDensity=min((1.0-pow(0.0125,c))*2.0,1.0);
	float cloudsDensity2=min((1.0-pow(0.0125,c2))*2.0,1.0);
	
	cloudsNoise2*=cloudsDensity2;
	//cloudsNoise2+=scatterLight;
	
	vec3 cColor=mix(cloudsColor+scatterLight,SUN*cloudsMat.x,cloudAlpha2);
	vec3 cBackLight1=vec3(pow((1.0-cloudsDensity)+1.0,10.0)*0.001);
	cBackLight1 = (cBackLight1+backLight)*cloudAlpha2;
	
	vec3 cloudsColorFinal=cColor+cBackLight1;
	skycolor=mix(skycolor+((SUN+scatterLight)*cloudsNoise2),cloudsColorFinal,cloudsDensity); 
	
	gl_FragColor.xyz=skycolor;
	gl_FragColor.a=clamp(1.0-cloudsDensity,0.0,1.0);
	*/
	
	////////////////////////////////////////////
	/*vec4 skycolor=texture2D(cirrusTex,texcoords.st+vec2(ofs.x,0.0));
	skycolor+=texture2D(cirrusTex,texcoords.st+vec2(-ofs.x,0.0));
	skycolor+=texture2D(cirrusTex,texcoords.st+vec2(0.0,ofs.y));
	skycolor+=texture2D(cirrusTex,texcoords.st+vec2(0.0,-ofs.y));
	skycolor+=texture2D(cirrusTex,texcoords.st);
	
	*/

//	vec3 vdir=normalize(-cnormal);
//	vec3 transmittance=vec3(1,1,1);
//	vec3 scattering;
//	scattering=GetSkyRadiance(vec3(0.0,0.0,0.0)-earth_center,vdir,0.0,-sundir,transmittance);

	/*if(cloudsTexcoords.y<0.5)
		discard;
		*/
	vec3 skycolor=texture2D(cloudsTex,cloudsTexcoords.st);
/*	skycolor+=texture2D(cloudsTex,cloudsTexcoords.st+vec2(-ofs.x,0.0));
	skycolor+=texture2D(cloudsTex,cloudsTexcoords.st+vec2(0.0,ofs.y));
	skycolor+=texture2D(cloudsTex,cloudsTexcoords.st+vec2(0.0,-ofs.y));
	skycolor+=texture2D(cloudsTex,cloudsTexcoords.st);
	*/
	gl_FragColor.xyz=skycolor.xyz;//*vec3(0.2);//skycolor.xyz;//*vec3(0.2);
	gl_FragColor.a=1.0;//clamp(1.0-cloudsDensity,0.0,1.0);
}
